<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ClientHistory;
use App\Models\Client;
use App\Http\Requests\ClientHistory\Index;
use App\Http\Requests\ClientHistory\Show;
use App\Http\Requests\ClientHistory\Create;
use App\Http\Requests\ClientHistory\Store;
use App\Http\Requests\ClientHistory\Edit;
use App\Http\Requests\ClientHistory\Update;
use App\Http\Requests\ClientHistory\Destroy;


/**
 * Description of ClientHistoryController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class ClientHistoryController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        $client_id = $request->get('client_id');
        $client = Client::find($client_id);
        if($client_id){
            return view('pages.client_history.index', ['client'=>$client,'records' => ClientHistory::where('client_id',$client_id)->paginate(10)]);
        }
        return view('pages.client_history.index', ['records' => ClientHistory::paginate(10)]);
    }    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  ClientHistory  $clienthistory
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, ClientHistory $clienthistory)
    {
        return view('pages.client_history.show', [
                'record' =>$clienthistory,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {
		$clients = Client::all(['id']);

        return view('pages.client_history.create', [
            'model' => new ClientHistory,
			"clients" => $clients,

        ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new ClientHistory;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'ClientHistory saved successfully');
            return redirect()->route('client_history.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving ClientHistory');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  ClientHistory  $clienthistory
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, ClientHistory $clienthistory)
    {
		$clients = Client::all(['id']);

        return view('pages.client_history.edit', [
            'model' => $clienthistory,
			"clients" => $clients,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  ClientHistory  $clienthistory
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,ClientHistory $clienthistory)
    {
        $clienthistory->fill($request->all());

        if ($clienthistory->save()) {
            
            session()->flash('app_message', 'ClientHistory successfully updated');
            return redirect()->route('client_history.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating ClientHistory');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  ClientHistory  $clienthistory
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, ClientHistory $clienthistory)
    {
        if ($clienthistory->delete()) {
                session()->flash('app_message', 'ClientHistory successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting ClientHistory');
            }

        return redirect()->back();
    }
}
