<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\OrderActivity;
use App\Http\Requests\OrderActivities\Index;
use App\Http\Requests\OrderActivities\Show;
use App\Http\Requests\OrderActivities\Create;
use App\Http\Requests\OrderActivities\Store;
use App\Http\Requests\OrderActivities\Edit;
use App\Http\Requests\OrderActivities\Update;
use App\Http\Requests\OrderActivities\Destroy;


/**
 * Description of OrderActivityController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class OrderActivityController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        return view('pages.order_activities.index', ['records' => OrderActivity::paginate(10)]);
    }    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  OrderActivity  $orderactivity
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, OrderActivity $orderactivity)
    {
        return view('pages.order_activities.show', [
                'record' =>$orderactivity,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {

        return view('pages.order_activities.create', [
            'model' => new OrderActivity,

        ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new OrderActivity;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'Actividad de orden guardada con éxito');
            return redirect()->route('orders.manage', ['id' => $model->order_id]);
            } else {
                session()->flash('app_message', 'Something is wrong while saving OrderActivity');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  OrderActivity  $orderactivity
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, OrderActivity $orderactivity)
    {

        return view('pages.order_activities.edit', [
            'model' => $orderactivity,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  OrderActivity  $orderactivity
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,OrderActivity $orderactivity)
    {
        $orderactivity->fill($request->all());

        if ($orderactivity->save()) {
            
            session()->flash('app_message', 'OrderActivity successfully updated');
            return redirect()->route('order_activities.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating OrderActivity');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  OrderActivity  $orderactivity
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, OrderActivity $orderactivity)
    {
        if ($orderactivity->delete()) {
                session()->flash('app_message', 'OrderActivity successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting OrderActivity');
            }

        return redirect()->back();
    }
}
