<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Promo;
use App\Models\PromoDetail;
use App\Http\Requests\Promos\Index;
use App\Http\Requests\Promos\Show;
use App\Http\Requests\Promos\Create;
use App\Http\Requests\Promos\Store;
use App\Http\Requests\Promos\Edit;
use App\Http\Requests\Promos\Update;
use App\Http\Requests\Promos\Destroy;


/**
 * Description of PromoController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class PromoController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        $promos = PromoDetail::join('promos', 'promo_details.promo_id', '=', 'promos.id')
        ->where('promos.status',1)
        ->get();
    return view('pages.promos.index_promos', compact('promos'));
    } 
    
    public function index_manage()
    {
        $promos = Promo::all();
        return view('pages.promos.index_manage', compact('promos'));
    }
    
    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  Promo  $promo
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, Promo $promo)
    {
        return view('pages.promos.show', [
                'record' =>$promo,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {

        return view('forms.promo_upload');

        // return view('pages.promos.create', [
        //     'model' => new Promo,

        // ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new Promo;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'Promo saved successfully');
            return redirect()->route('promos.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving Promo');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  Promo  $promo
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, Promo $promo)
    {

        return view('pages.promos.edit', [
            'model' => $promo,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  Promo  $promo
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,Promo $promo)
    {

        // return json_encode($request->all());
        
        $promo->fill($request->all());

        $promo->status = !$promo->status;

        $promo->save();

        return redirect()->route('promos_manage')

            ->with('success','Promo actualizada correctamente');

        // if ($promo->save()) {
            
        //     session()->flash('app_message', 'Promo successfully updated');
        //     return redirect()->route('promos.index');
        //     } else {
        //         session()->flash('app_error', 'Something is wrong while updating Promo');
        //     }
        // return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  Promo  $promo
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, Promo $promo)
    {
        if ($promo->delete()) {
                session()->flash('app_message', 'Promo successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting Promo');
            }

        return redirect()->back();
    }
}
