<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Spatie\Permission\Models\Role;
use App\Http\Requests\Users\Index;
use App\Http\Requests\Users\Show;
use App\Http\Requests\Users\Create;
use App\Http\Requests\Users\Store;
use App\Http\Requests\Users\StorePartner;
use App\Http\Requests\Users\Edit;
use App\Http\Requests\Users\Update;
use App\Http\Requests\Users\Destroy;
use App\Models\Canton;
use App\Models\GteBodega;
use App\Models\Parish;
use App\Models\UserWarehouse;
use App\Models\Warehouse;
use App\Models\ParentChange;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

/**
 * Description of UserController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class UserController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        return view('pages.users.index', ['records' => User::paginate(10)]);
    }    
    
    public function index_partners(Index $request)
    {
        $user = Auth::user();
       
        $users = User::where('type', 'MTNL')
        ->where('parent_document', $user->document)
        ->when($request->has('search'), function($query) use ($request) {
            $query->where('name', 'like', '%' . $request->input('search') . '%');
            $query->orWhere('document', 'like', '%' . $request->input('search') . '%');
        })
        ->paginate(10);
        return view('pages.users.index_partners', ['records' => $users]);
    }
    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, User $user)
    {
        return view('pages.users.show', [
                'record' =>$user,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {


        $roles = Role::pluck('name', 'name')->all();
        $warehouses = GteBodega::pluck('DESCRIPCION','BODEGA_ID')->all();
        // return $userWarehouses;

        // return $userRoles;

        return view('pages.users.create', [
            'model' => new User,
            'roles' => $roles,
            'userRoles' => [],
            'warehouses' => $warehouses,
            'userWarehouses' => [],
            ]);
    }
    
    public function partner_create(Create $request)
    {
        $provinces = DB::table('provinces')->get();

        return view('pages.users.partner_create', [
            'model' => new User,
            'parent' => Auth::user(),
            'provinces' => $provinces

        ]);
    } 
    
    public function index_manage(Request $request)
    {
        $partners = User::where('type', 'MTNL')
        ->when($request->has('search'), function($query) use ($request) {
            $query->where('name', 'like', '%' . $request->input('search') . '%');
            $query->orWhere('document', 'like', '%' . $request->input('search') . '%');
        })
        ->paginate(10);

        return view('pages.users.index_manage', [
            'records' => $partners
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new User;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'User saved successfully');
            return redirect()->route('users.index');
        } else {
                session()->flash('app_message', 'Something is wrong while saving User');
        }
        return redirect()->back();
    }

        /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store_partner(StorePartner $request)
    {
        $model=new User;
        $model->entry_date = date('Y-m-d');
        $model->status = 'P';
        $model->type = 'MTNL';
        $model->password = bcrypt($request->input('password'));
        $model->name = strtoupper($request->input('middlename').' '.$request->input('lastname').' '.$request->input('names'));
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'User saved successfully');
            return redirect()->route('users.index');
        } else {
                session()->flash('app_message', 'Something is wrong while saving User');
        }
        return redirect()->back();
    }

    public function register(Store $request)
    {
        $model=new User;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'User saved successfully');
            return redirect()->route('users.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving User');
            }
        return redirect()->back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, User $user)
    {

        $roles = Role::pluck('name', 'name')->all();
        $warehouses = GteBodega::pluck('DESCRIPCION','BODEGA_ID')->all();
        $userRoles = $user->roles->pluck('name', 'name')->all();
        $userWarehouses = $user->warehouses()->pluck('DESCRIPCION', 'DESCRIPCION')->all();
        // return $userWarehouses;

        // return $userRoles;

        return view('pages.users.edit', [
            'model' => $user,
            'roles' => $roles,
            'userRoles' => $userRoles,
            'warehouses' => $warehouses,
            'userWarehouses' => $userWarehouses,
            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,User $user)
    {
        $user->fill($request->all());

        if ($user->save()) {
            
            session()->flash('app_message', 'User successfully updated');

            // Update warehouses
            UserWarehouse::where('user_id', $user->id)->delete();

            $warehouses = $request->input('warehouses') ?? [];

            foreach ($warehouses as $warehouse) {
                $userWarehouse = new UserWarehouse;
                $userWarehouse->user_id = $user->id;
                $userWarehouse->warehouse_id = $warehouse;
                $userWarehouse->save();
            }

            // roles

            DB::table('model_has_roles')->where('model_id', $user->id)->delete();

            $user->assignRole($request->input('roles'));

            return redirect()->route('users.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating User');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  User  $user
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */

    public function updateStatus(Request $request)
    {
         $id = $request->id;
         $status = $request->status;
         $reason_status = $request->reason_status;
 
         if ($id != '') {
             $user = User::find($id);
             $user->status = $status;
             $user->reason_status = $reason_status;
             $user->updated_by = Auth::id();
 
             if ($user->save()) {
 
                 Log::info('--- UPDATED USER --- IP: ' . $request->ip() . ' DOCUMENT: ' . $user->document . ' UPDATED_BY: ' . Auth::id());
 
                 $estado = '';
                 $user->status == 'A' ? $estado = 'Activo' : '';
                 $user->status == 'P' ? $estado = 'Pendiente' : '';
                 $user->status == 'AP' ? $estado = 'Aprobado' : '';
                 $user->status == 'R' ? $estado = 'Rechazado' : '';
                 $user->status == 'I' ? $estado = 'Inactivo' : '';

                 $message = 'Se ha cambiado el estado del usuario ' . $user->name . ' a ' . $estado;
 

                 return json_encode(['status' => $user->status, 'message' => $message]);
             } else {
 
                 $message = 'No se ha podido cambiar el estado del usuario ' . $user->name;
 
                 return json_encode(['message' => $message]);
             }
         } else {
             return json_encode(['message' => 'No se ha podido cambiar el estado del usuario']);
         }
    }


    public function modifyParentUser(Request $request)
    {

        if ($request->method() == 'POST') {


            $userId = $request->id;
            $parent_document = $request->parent_document;

            $user = User::findOrFail($userId);

            $pexist = User::where('document', $parent_document)->count();

            if ($pexist > 0) {
                try {

                    $parent_change = new ParentChange();
                    $parent_change->document =  $user->document;
                    $parent_change->parent_document =  $user->parent_document;
                    $parent_change->new_parent_document =  $parent_document;
                    $parent_change->comment =  'modify parent user';
                    $parent_change->updated_by =  Auth::id();
                    $parent_change->save();

                    $user->parent_document = $parent_document;

                    $user->updated_by = Auth::id();

                    Log::info('--- UPDATED USER --- IP: ' . $request->ip() . ' DOCUMENT: ' . $user->document . ' UPDATED_BY: ' . Auth::id());

                    $saved = $user->save();
                } catch (\Exception $e) {
                    // do task when error
                    $message = $e->getMessage();   // insert query
                    return redirect()->action('UserController@index_manage', ['mensaje' => $message]);
                }


                if (!$saved) {

                    return redirect()->action('UserController@index_manage', ['mensaje' => 'No se ha podido guardar el registro']);
                } else {

                    // $respSync = $this->syncUserR($user->id);

                    return redirect()->action('UserController@index_manage', ['mensaje' => 'Perfil actualizado correctamente']);
                }
            } else {
                return redirect()->action('UserController@index_manage', ['mensaje' => 'No se ha encontrado el patrocinador con esa cédula']);
            }
        } else {

            return redirect()->action('UserController@index_manage');
        }
    }


    public function destroy(Destroy $request, User $user)
    {
        if ($user->delete()) {
                session()->flash('app_message', 'User successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting User');
            }

        return redirect()->back();
    }

    public function parishbycanton(Request $request)
    {
        $parishes = Parish::where('canton_id', $request->input('canton_id'))->get();
        return response()->json($parishes);
    }

    public function cantonbyprovince(Request $request)
    {
        $cantons = Canton::where('province_id', $request->input('province_id'))->get();
        return response()->json($cantons);
    }
}
