<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
/**
   @property bigint $client_id client id
@property varchar $type type
@property varchar $details details
@property timestamp $created_at created at
@property timestamp $updated_at updated at
@property Client $client belongsTo
   
 */
class ClientHistory extends Model 
{
    
    /**
    * Database table name
    */
    protected $table = 'client_history';

    /**
    * Mass assignable columns
    */
    protected $fillable=['client_id',
'type',
'details'];

    /**
    * Date time columns.
    */
    protected $dates=[];

    /**
    * client
    *
    * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
    */
    public function client()
    {
        return $this->belongsTo(Client::class,'client_id');
    }




}