<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

     /*
     Campo	Descripción	Tipo
Series	Serie del documento	Int
DocDate	Fecha de	Contabilización	Date
TaxDate	Fecha del Documento	Date
DocDueDate	Fecha de entrega	Date
CardCode	Código Socio de Negocio	Varchar (15)
SalesPersonCode	Empleado de Venta	(ver web
Int
service vendedores)
Comments	Comentario	Varchar (254)
DiscountPercent	Porcentaje de Descuento	global	Numeric
DocType	Tipo de documento (	Siempre I	) Varchar (1 )
BPL_IDAssignedToInvoice	Códi go de sucursal	Int
     */
    public function up(): void
    {
        Schema::create('order_header', function (Blueprint $table) {
            $table->id();
            $table->integer('Series')->nullable();
            $table->date('DocDate')->nullable();
            $table->date('TaxDate')->nullable();
            $table->date('DocDueDate')->nullable();
            $table->string('CardCode',15)->nullable();
            $table->integer('SalesPersonCode')->nullable();
            $table->string('Comments',254)->nullable();
            $table->decimal('DiscountPercent',18,6)->nullable();
            $table->string('DocType',1)->nullable();
            $table->integer('BPL_IDAssignedToInvoice')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_header');
    }
};
