<form action="{{ isset($route) ? $route : url('storeorder') }}" method="POST">
    {{ csrf_field() }}
    <input type="hidden" name="_method" value="{{ isset($method) ? $method : 'POST' }}" />
    <input type="hidden" name="id" value="{{ $model->id }}" />
    <div class="row">

        <fieldset class="row">
            <legend>Datos</legend>

        <div class="form-group col-4">
            <label for="CardCode">{{__('orders.CardCode')}}</label>
            <span class="form-control">{{ $client_code ?? $model->CardCode }}</span>
            <input type="hidden" name="CardCode" value="{{ $client_code ?? $model->CardCode }}" />

        </div>

        <div class="form-group col-4">
            <label for="CardName">{{__('orders.CardName')}}</label>
            <span class="form-control">{{ $client_name ?? $model->CardName }}</span>
            <input type="hidden" name="CardName" value="{{ $client_name ?? $model->CardName }}" />

        </div>
        

        <input type="hidden" name="source" value="{{$source}}" />
        <input type="hidden" name="new_client" value="{{isset($new_client) ? $new_client : (isset($model->new_client)?$model->new_client:false)}}" />

        <div class="form-group col-4">
            <label for="Comments">{{__("orders.Comments")}}</label>
            <input type="text" class="form-control {{ $errors->has('Comments') ? ' is-invalid' : '' }}"
                name="Comments" id="Comments" value="{{ old('Comments', $model->Comments) }}" placeholder=""
                maxlength="254">
            @if ($errors->has('Comments'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('Comments') }}</strong>
                </div>
            @endif
        </div>
{{-- 
        <div class="form-group col-2">
            <label for="DiscountPercent">{{__("orders.DiscountPercent")}}</label>
            <input type="number" class="form-control {{ $errors->has('DiscountPercent') ? ' is-invalid' : '' }}"
                name="DiscountPercent" id="DiscountPercent"
                value="{{ old('DiscountPercent', $model->DiscountPercent) }}" placeholder="">
            @if ($errors->has('DiscountPercent'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('DiscountPercent') }}</strong>
                </div>
            @endif
        </div> --}}
        </fieldset>


        {{-- <div class="form-group col-3">
            <label for="Type">{{__("orders.Type")}}</label>
            <select class="form-control {{ $errors->has('Type') ? ' is-invalid' : '' }} select2" name="Type"
                id="Type" value="{{ old('Type', $model->Type) }}" placeholder="" maxlength="1">
                <option value="">-- Seleccione Categoría --</option>
                @foreach ($types as $type)
                    <option value="{{ $type->LINEA_ID }}" {{ $type->LINEA_ID == $model->LINEA_ID ? 'selected' : '' }}>
                        {{ $type->DESCRIPCION }}</option>
                @endforeach
            </select>
        </div> --}}

        <div class="form-group col-3">
            <label for="warehouse_id">{{__("orders.warehouse")}}</label>
            <select class="form-control {{ $errors->has('warehouse_id') ? ' is-invalid' : '' }} select2" name="warehouse_id"
                id="warehouse_id" value="{{ old('warehouse_id', $model->warehouse_id) }}" placeholder="" maxlength="15">
                @foreach ($warehouses as $wareshouse)
                    <option value="{{ $wareshouse->BODEGA_ID }}"
                        {{ $wareshouse->BODEGA_ID == $model->wareshouse_id ? 'selected' : '' }}>
                        {{ $wareshouse->DESCRIPCION }}</option>
                @endforeach

            </select>
            @if ($errors->has('warehouse_id'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('warehouse_id') }}</strong>
                </div>
            @endif
        </div>
        
        <div class="form-group col-8">
            <label for="Product">{{__("orders.Product")}}</label>
            <select class="form-control {{ $errors->has('Product') ? ' is-invalid' : '' }} select2" name="Product"
                id="Product" value="{{ old('Product', $model->Product) }}" placeholder="" maxlength="1">
                @foreach ($products as $product)
                    <option value="{{ $product->code }}" {{ $product->code == $model->Product ? 'selected' : '' }}>
                        {{ $product->name }}</option>
                @endforeach
            </select>

        </div>



        {{-- <div class="form-group col-3">
            <label for="Make">Make</label>
            <select class="form-control {{ $errors->has('Make') ? ' is-invalid' : '' }} select2" name="Make"
                id="Make" value="{{ old('Make', $model->Make) }}" placeholder="" maxlength="1">
                <option value="I" {{ $model->Make == 'I' ? 'selected' : '' }}>I</option>
                <option value="S" {{ $model->Make == 'S' ? 'selected' : '' }}>S</option>
            </select>
        </div>


        <div class="form-group col-2">
            <label for="Model">Model</label>
            <select class="form-control {{ $errors->has('Model') ? ' is-invalid' : '' }} select2" name="Model"
                id="Model" value="{{ old('Model', $model->Model) }}" placeholder="" maxlength="1">
                <option value="I" {{ $model->Model == 'I' ? 'selected' : '' }}>I</option>
                <option value="S" {{ $model->Model == 'S' ? 'selected' : '' }}>S</option>
            </select>
        </div> --}}

        <div class="form-group col-1 p-3">
            <a class="btn btn-success" value="Add" id="AddProduct"> + </a>
        </div>


        <div class="form-group col-12">
            <table class="table table-striped table-hover" id="productsDetail">
                <thead>
                    <tr>
                        <th>{{__("orders.Type")}}</th>
                        <th>{{__("orders.Code")}}</th>
                        {{-- <th>Make</th>
                        <th>Model</th>
                        <th>Measure</th> --}}
                        <th>{{__("orders.Quantity")}}</th>
                        <th>{{__("orders.Price")}}</th>
                        <th>{{__("orders.Discount")}}</th>
                        <th>{{__("orders.Total")}}</th>
                        <th>{{__("orders.Comments")}}</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    {{-- @foreach ($model->orderDetails as $detail)
                        <tr id="{{ $detail->ItemCode }}">
                            <td>{{ $detail->product?->linea->DESCRIPCION }}</td>
                            <td>{{ $detail->ItemCode }}</td>
                            <td>{{ $detail->Quantity }}</td>
                            <td>{{ $detail->UnitPrice }}</td>
                            <td>{{ $detail->DiscountPercent }}</td>
                            <td>{{ $detail->Quantity * $detail->UnitPrice }}</td>
                            <td>{{ $detail->observations }}</td>
                            <td><a class="btn btn-danger deleteRow" product_code="{{ $detail->code }}"> x </a></td>
                        </tr>
                    @endforeach --}}

                </tbody>
            </table>
        </div>

        <div class="form-group col-12">
            <div class="float-end">
                <table>
                    <tr>
                        <td>Descuento: </td>
                        <td> <h4 id="discount"></h4></td>
                    </tr>
                    <tr>
                        <td>Subtotal: </td>
                        <td> <h4 id="subtotal"></h4></td>
                    </tr>
                    <tr>
                        <td>Iva 15%: </td>
                        <td> <h4 id="iva"></h4></td>
                    </tr>
                    <tr>
                        <td>Total: </td>
                        <td> <h4 id="total"></h3></td>
                    </tr>
                </table>
            </div>
        </div>


        <div class="form-group text-right ">
            <input type="submit" class="btn btn-primary" value="{{__('pages.save')}}" />

        </div>
    </div>
</form>
@push('custom-scripts')
    {{-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script> --}}
    {{-- <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script> --}}
    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.8/js/select2.min.js" defer></script> --}}
    <script type="module">
        $(document).ready(function() {
            let products = @json($products);

            let detail_products = @json($model->orderDetails);

            let row_index = 0;

            // let order_details = [];


            $('.select2').select2({
                theme: "classic"
            });

            // $('#Type').on('change', function() {
            //     var type = this.value;
            //     $("#Make").html('');
            //     $.ajax({
            //         url: "{{ url('productsbytype') }}",
            //         type: "POST",
            //         data: {
            //             type: type,
            //             warehouse_id: $('#warehouse_id').val(),
            //             _token: '{{ csrf_token() }}'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             $('#Make').html('<option value="">-- Seleccione Marca --</option>');
            //             $.each(result.makes, function(key, value) {
            //                 $("#Make").append('<option value="' + value
            //                     .make + '">' + value.make + '</option>');
            //             });
            //             fillProducts(result.products);
            //             $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
            //         }
            //     });
            // });

            $('#warehouse_id').on('change', function() {
                var warehouse_id = this.value;
                // var type = $('#Type').val();
                $.ajax({
                    url: "{{ url('productsbysearch') }}",
                    type: "POST",
                    data: {
                        // type: type,
                        warehouse_id: warehouse_id,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#Make').html('<option value="">-- Seleccione Marca --</option>');
                        $.each(result.makes, function(key, value) {
                            $("#Make").append('<option value="' + value
                                .make + '">' + value.make + '</option>');
                        });
                        fillProducts(result.products);
                        $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
                    }
                });
            });

            //do the same for make

            // $('#Make').on('change', function() {
            //     var make = this.value;
            //     var type = $('#Type').val();
            //     $.ajax({
            //         url: "{{ url('productsbymake') }}",
            //         type: "POST",
            //         data: {
            //             make: make,
            //             type: type,
            //             _token: '{{ csrf_token() }}'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
            //             $.each(result.models, function(key, value) {
            //                 $("#Model").append('<option value="' + value
            //                     .model + '">' + value.model + '</option>');
            //             });
            //             fillProducts(result.products);
            //         }
            //     });
            // });

            // //do the same for model
            // $('#Model').on('change', function() {
            //     var model = this.value;
            //     var make = $('#Make').val();
            //     var type = $('#Type').val();
            //     $.ajax({
            //         url: "{{ url('productsbymodel') }}",
            //         type: "POST",
            //         data: {
            //             model: model,
            //             make: make,
            //             type: type,
            //             _token: '{{ csrf_token() }}'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             fillProducts(result.products);
            //         }
            //     });
            // });

            console.log('detail_products', detail_products);

            if ( detail_products && detail_products.length > 0) {
                for (let i = 0; i < detail_products.length; i++) {
                    const detail = detail_products[i];
                    const product = products.find(product => {
                        return product.PRODUCTO_ID == detail.ItemCode;
                    });
                    rawProducto(product,detail.Quantity,detail.DiscountPercent);
                }
                calculateTotal();
            }

            

            function fillProducts(products) {
                $("#Product").html('');
                //if no products found alert the user
                if (products.length == 0) {
                    alert('No hay productos disponibles para esta categoría en esta bodega');
                    return;
                }
                $.each(products, function(key, value) {
                    $("#Product").append('<option value="' + value
                        .PRODUCTO_ID + '">' + value.NOMBRE_PRODUCTO + '</option>');
                });
            }

            //listener for new element .deleteRow

            $(".deleteRow").click(function() {
                console.log('hello');
                var product_code = $(this).data("product_code");
                $('#' + product_code).remove();
            });

            //add product to table
            $("#AddProduct").click(function() {
                const product_code = $('#Product').val();
                
                if(!product_code) {
                    alert('Debe seleccionar un producto');
                    return;
                }
                
                const product = products.find(product => {
                    return product.PRODUCTO_ID == product_code;
                });

                const productID = product.PRODUCTO_ID.replace(/\s/g, '');

                const productExists = $('#' + productID + '_quantity').length > 0;

                if(productExists) {
                    console.log("🚀 ~ file: order.blade.php:258 ~ $ ~ productExists:", productExists);
                    const quantity = $('#' + productID + '_quantity').val();
                    $('#' + productID + '_quantity').val(parseInt(quantity) + 1);
                    // //update total
                    updateProduct(product.PRODUCTO_ID);
                    // const total = $('#' + product.PRODUCTO_ID + '_total').text();
                    // $('#' + product.PRODUCTO_ID + '_total').text(parseFloat(total).toFixed(2) + parseFloat(product.VALOR_PRODUCTO).toFixed(2));
                    // calculateTotal();
                    return;
                }
                rawProducto(product);
                calculateTotal();
            });

            function rawProducto(product,quantity = 1,discount = 0){
                const productID = product.PRODUCTO_ID.replace(/\s/g, '');
                const discountTotal = parseFloat(product.VALOR_PRODUCTO) * quantity * (discount / 100);
                const amount = parseFloat((product.VALOR_PRODUCTO * quantity) - discountTotal).toFixed(2);
                const row = '<tr id="' + productID + '">' +
                    '<td>' + product.DESCRIPCION +'</td>' +
                    '<td><input class="form-control" value=" ' + product.PRODUCTO_ID +'" name="details[' + row_index + '][code]" readonly/></td>' +
                   
                    '<td><input id="'+ productID +'_quantity" class="form-control" value="' + quantity + '" name="details[' + row_index + '][quantity]" type="number" step="1" onclick="updateProduct(\'' + product.PRODUCTO_ID + '\')"/></td>'+
                    '<td><input class="form-control" value=" ' + parseFloat(product.VALOR_PRODUCTO) + '" name="details['+ row_index +'][price]" readonly/></td>'+
                    '<td><input id="'+ productID +'_discount" class="form-control" value="' + discount + '" name="details[' + row_index + '][discount]" type="number" step="1" onclick="updateProduct(\'' + product.PRODUCTO_ID + '\')"/></td>'+
                    '<td id="'+ productID +'_total">' + amount + '</td>' +
                    '<td><input class="form-control" name="details[' + row_index + '][observations]" /> </td>'+
                    '<td><a class="btn btn-danger deleteRow"  product_code="' + productID + '" onclick="deleteRow(\'' + productID + '\')"> x </a></td>'+
                    '</tr>';
                $('#productsDetail tbody').append(row);
                row_index++;
                // calculateTotal();
            }

            function calculateTotal() {
                const iva = 0.15;
                let total = 0;
                let totalDiscount = 0;
                const subtotalColumn = 5;
                const discountColumn = 4;
                const quantityColumn = 2;
                const priceColumn = 3;
                $('#productsDetail tbody tr').each(function() {
                    const subtotal = $(this).find('td').eq(subtotalColumn).text();
                    const price = $(this).find('td').eq(priceColumn).find('input').val();
                    total += parseFloat(subtotal);
                    const quantity = $(this).find('td').eq(quantityColumn).find('input').val();
                    const discount = $(this).find('td').eq(discountColumn).find('input').val();
                    const productDiscount = quantity * price * (discount / 100);
                    totalDiscount += parseFloat(productDiscount);

                });
                $('#discount').text(totalDiscount.toFixed(2));
                $('#subtotal').text(total.toFixed(2));
                $('#iva').text(parseFloat(total * iva).toFixed(2));
                $('#total').text(parseFloat(total + (total * iva), 2).toFixed(2));
            }


            const updateProduct = function(product_code) {
                var product = products.find(product => {
                    return product.PRODUCTO_ID == product_code;
                });
                const productID = product.PRODUCTO_ID.replace(/\s/g, '');
                const total = $('#' + productID + '_total').text();
                const quantity = $('#' + productID + '_quantity').val();
                const discount = $('#' + productID + '_discount').val();

                const totalDiscount = quantity * parseFloat(product.VALOR_PRODUCTO) * (discount / 100);

                $('#' + productID + '_total').text( (quantity * parseFloat(product.VALOR_PRODUCTO) - totalDiscount ).toFixed(2));
                calculateTotal();
            }


            const deleteRow = function(product_code) {
                $('#' + product_code).remove();
            }

            $('#warehouse_id').trigger('change');

            window.updateProduct = updateProduct;
            window.deleteRow = deleteRow;
        });
    </script>
@endpush
