<form action="{{ isset($route) ? $route : route('order_activities.store') }}" method="POST" class="inline" id="order_activity_form">
    {{ csrf_field() }}
    <div class="row">
    <input type="hidden" name="_method" value="{{ isset($method) ? $method : 'POST' }}" />
    <input type="hidden" name="order_id" value="{{ old('order_id', $record->id) }}" />
    <input type="hidden" name="user_id" value="{{ old('user_id', $record->user_id) }}" />

    <div class="form-group col-6">
        <label for="activity">{{__('orders.activity')}}</label>
        {{-- //add select with activities 'Llamada', 'Correo', 'Whatsapp/Redes Sociales', 'Otro', 'Incontactable' --}}
        <select class="form-control {{ $errors->has('activity') ? ' is-invalid' : '' }} select2" name="activity"
            id="activity" value="{{ old('activity', $record->activity) }}" placeholder="" maxlength="15">
            <option value="Llamada" {{ $record->activity == "Llamada"? "selected":"" }}>Llamada</option>
            <option value="Correo" {{ $record->activity == "Correo"? "selected":"" }}>Correo</option>
            <option value="Whatsapp/Redes Sociales" {{ $record->activity == "Whatsapp/Redes Sociales"? "selected":"" }}>Whatsapp/Redes Sociales</option>
            <option value="Otro" {{ $record->activity == "Otro"? "selected":"" }}>Otro</option>
            <option value="Incontactable" {{ $record->activity == "Incontactable"? "selected":"" }}>Incontactable</option>
        </select>
        {{-- <input type="text" class="form-control {{ $errors->has('activity') ? ' is-invalid' : '' }}" name="activity"
            id="activity" value="{{ old('activity', $record->activity) }}" placeholder="" maxlength="255"> --}}
        @if ($errors->has('activity'))
            <div class="invalid-feedback">
                <strong>{{ $errors->first('activity') }}</strong>
            </div>
        @endif
    </div>

    <div class="form-group col-6">
      <label for="followup_date">{{__('orders.followup_date')}}</label>
      <div class="input-group">
          <input type="date" class="form-control {{ $errors->has('followup_date') ? ' is-invalid' : '' }}"
              name="followup_date" id="followup_date" value="{{ old('followup_date', $record->followup_date) }}"
              placeholder="" min="{{date('Y-m-d')}}">
          <div class="input-group-addon">
              <label for="followup_date" class="fa fa-calendar">
              </label>
          </div>
      </div>
      @if ($errors->has('followup_date'))
          <div class="invalid-feedback">
              <strong>{{ $errors->first('followup_date') }}</strong>
          </div>
      @endif
  </div>

    <div class="form-group col-11">
        <label for="comments">{{__('orders.comments')}}</label>
        <input type="text" class="form-control {{ $errors->has('comments') ? ' is-invalid' : '' }}" name="comments"
            id="comments" value="{{ old('comments', $record->comments) }}" placeholder="" maxlength="255">
        @if ($errors->has('comments'))
            <div class="invalid-feedback">
                <strong>{{ $errors->first('comments') }}</strong>
            </div>
        @endif
    </div>

    
    <div class="form-group col-1 p-3">
      {{-- <a class="btn btn-success" value="Add" id="AddProduct"> + </a> --}}
      <input type="submit" class="btn btn-success" value="+" />
    </div>

    {{-- <div class="form-group text-right ">
        <input type="reset" class="btn btn-default" value="Clear" />
        <input type="submit" class="btn btn-primary" value="Save" />

    </div> --}}
    </div>
</form>
