
    <form action="{{ isset($route) ? $route : route('users.store') }}" method="POST" class="row">
        {{ csrf_field() }}
        <input type="hidden" name="_method" value="{{ isset($method) ? $method : 'POST' }}" />
        <div class="form-group col-md-2">
            <label for="name">{{__("users.Name")}}</label>
            <input type="text" class="form-control {{ $errors->has('name') ? ' is-invalid' : '' }}" name="name"
                id="name" value="{{ old('name', $model->name) }}" placeholder="" maxlength="255" required="required">
            @if ($errors->has('name'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('name') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group col-md-2">
            <label for="email">{{__("users.Email")}}</label>
            <input type="text" class="form-control {{ $errors->has('email') ? ' is-invalid' : '' }}" name="email"
                id="email" value="{{ old('email', $model->email) }}" placeholder="" maxlength="255" required="required">
            @if ($errors->has('email'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('email') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group col-md-2">
            <label for="document">{{__("users.Document")}}</label>
            <input type="text" class="form-control {{ $errors->has('document') ? ' is-invalid' : '' }}" name="document"
                id="document" value="{{ old('document', $model->document) }}" placeholder="" maxlength="13"
                required="required">
            @if ($errors->has('document'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('document') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group col-md-2">
            <label for="parent_document">{{__("users.Parent Document")}}</label>
            <input type="text" class="form-control {{ $errors->has('parent_document') ? ' is-invalid' : '' }}"
                name="parent_document" id="parent_document" value="{{ old('parent_document', $model->parent_document) }}"
                placeholder="" maxlength="13" required="required">
            @if ($errors->has('parent_document'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('parent_document') }}</strong>
                </div>
            @endif
        </div>

        <div class="form-group  col-md-2">
            <label for="type">{{__("users.Type")}}</label>
            <input type="text" class="form-control {{ $errors->has('type') ? ' is-invalid' : '' }}" name="type"
                id="type" value="{{ old('type', $model->type) }}" placeholder="" maxlength="100">
            @if ($errors->has('type'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('type') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group col-md-2">
          <label for="password">{{__("users.Password")}}</label>
          <input type="password" class="form-control {{ $errors->has('password') ? ' is-invalid' : '' }}"
              name="password" id="password" value="{{ old('password', $model->password) }}"
              placeholder="" maxlength="13" required="required">
          @if ($errors->has('password'))
              <div class="invalid-feedback">
                  <strong>{{ $errors->first('password') }}</strong>
              </div>
          @endif
      </div>
    
        <div class="form-group  col-md-2">
            <label for="address">{{__("users.Address")}}</label>
            <input type="text" class="form-control {{ $errors->has('address') ? ' is-invalid' : '' }}" name="address"
                id="address" value="{{ old('address', $model->address) }}" placeholder="" maxlength="255">
            @if ($errors->has('address'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('address') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group   col-md-2">
            <label for="movile">{{__("users.Movile")}}</label>
            <input type="text" class="form-control {{ $errors->has('movile') ? ' is-invalid' : '' }}" name="movile"
                id="movile" value="{{ old('movile', $model->movile) }}" placeholder="" maxlength="50">
            @if ($errors->has('movile'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('movile') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group   col-md-2">
            <label for="phone">{{__("users.Phone")}}</label>
            <input type="text" class="form-control {{ $errors->has('phone') ? ' is-invalid' : '' }}" name="phone"
                id="phone" value="{{ old('phone', $model->phone) }}" placeholder="" maxlength="50">
            @if ($errors->has('phone'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('phone') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-grou col-md-2">
            <label for="genre">{{__("users.Genre")}}</label>
            <select class="form-control {{ $errors->has('genre') ? ' is-invalid' : '' }}" name="genre" id="genre">
                <option value="M" {{ old('genre', $model->genre) == 'M' ? 'selected' : '' }}>M</option>
                <option value="F" {{ old('genre', $model->genre) == 'F' ? 'selected' : '' }}>F</option>
            </select>
            @if ($errors->has('genre'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('genre') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group col-md-2">
            <label for="birthday">{{__("users.Birthday")}}</label>
            <div class="input-group">
                <input type="date" class="form-control {{ $errors->has('birthday') ? ' is-invalid' : '' }}"
                    name="birthday" id="birthday" value="{{ old('birthday', $model->birthday) }}" placeholder="">
                <div class="input-group-addon">
                    <label for="birthday" class="fa fa-calendar">
                    </label>
                </div>
            </div>
            @if ($errors->has('birthday'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('birthday') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group  col-md-2">
            <label for="civil_status">{{__("users.Civil Status")}}</label>
            <select class="form-control {{ $errors->has('civil_status') ? ' is-invalid' : '' }}" name="civil_status"
                id="civil_status">
                <option value="S" {{ old('civil_status', $model->civil_status) == 'S' ? 'selected' : '' }}>S</option>
                <option value="C" {{ old('civil_status', $model->civil_status) == 'C' ? 'selected' : '' }}>C</option>
                <option value="D" {{ old('civil_status', $model->civil_status) == 'D' ? 'selected' : '' }}>D</option>
                <option value="V" {{ old('civil_status', $model->civil_status) == 'V' ? 'selected' : '' }}>V</option>
            </select>
            @if ($errors->has('civil_status'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('civil_status') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group  col-md-2">
            <label for="country">{{__("users.Country")}}</label>
            <input type="text" class="form-control {{ $errors->has('country') ? ' is-invalid' : '' }}" name="country"
                id="country" value="{{ old('country', $model->country) }}" placeholder="" maxlength="100">
            @if ($errors->has('country'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('country') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group  col-md-2">
            <label for="province">{{__("users.Province")}}</label>
            <input type="text" class="form-control {{ $errors->has('province') ? ' is-invalid' : '' }}"
                name="province" id="province" value="{{ old('province', $model->province) }}" placeholder=""
                maxlength="100">
            @if ($errors->has('province'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('province') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group  col-md-2">
            <label for="city">{{__("users.City")}}</label>
            <input type="text" class="form-control {{ $errors->has('city') ? ' is-invalid' : '' }}" name="city"
                id="city" value="{{ old('city', $model->city) }}" placeholder="" maxlength="100">
            @if ($errors->has('city'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('city') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group   col-md-2">
            <label for="bank">{{__("users.Bank")}}</label>
            <input type="text" class="form-control {{ $errors->has('bank') ? ' is-invalid' : '' }}" name="bank"
                id="bank" value="{{ old('bank', $model->bank) }}" placeholder="" maxlength="100">
            @if ($errors->has('bank'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('bank') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group  col-md-2">
            <label for="account_number">{{__("users.Account Number")}}</label>
            <input type="text" class="form-control {{ $errors->has('account_number') ? ' is-invalid' : '' }}"
                name="account_number" id="account_number" value="{{ old('account_number', $model->account_number) }}"
                placeholder="" maxlength="100">
            @if ($errors->has('account_number'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('account_number') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group  col-md-2">
            <label for="account_type">{{__("users.Account Type")}}</label>
            <select class="form-control {{ $errors->has('account_type') ? ' is-invalid' : '' }}" name="account_type"
                id="account_type">
                <option value="A" {{ old('account_type', $model->account_type) == 'Ahorros' ? 'selected' : '' }}>A</option>
                <option value="C" {{ old('account_type', $model->account_type) == 'Corriente' ? 'selected' : '' }}>C</option>
            </select>
            @if ($errors->has('account_type'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('account_type') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group col-md-2">
            <label for="entry_date">{{__("users.Entry Date")}}</label>
            <div class="input-group">
                <input type="date" class="form-control {{ $errors->has('entry_date') ? ' is-invalid' : '' }}"
                    name="entry_date" id="entry_date" value="{{ old('entry_date', $model->entry_date) }}" placeholder="">
                <div class="input-group-addon">
                    <label for="entry_date" class="fa fa-calendar">
                    </label>
                </div>
            </div>
            @if ($errors->has('entry_date'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('entry_date') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group  col-md-2">
            <label for="roles">{{__("users.Roles")}}</label>
            <select class="form-control {{ $errors->has('roles') ? ' is-invalid' : '' }} select2" name="roles"
                id="roles">
                <option value="">{{__('users.select')}}...</option>
                @foreach ($roles as $role)
                <option value="{{ $role }}" {{ in_array($role,$userRoles) ? 'selected' : '' }}>{{ $role }}</option>
                @endforeach
            </select>
            @if ($errors->has('roles'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('roles') }}</strong>
                </div>
            @endif
        </div>
    
        <div class="form-group  col-md-2">
            <label for="warehouses">{{__("users.warehouses")}}</label>
            <select class="form-control {{ $errors->has('warehouses') ? ' is-invalid' : '' }} select2" name="warehouses[]"
                id="warehouses" multiple>
                <option value="">{{__('users.select')}}...</option>
                @foreach ($warehouses as $key => $warehouse)
                <option value="{{ $key }}" {{ in_array($warehouse,$userWarehouses) ? 'selected' : '' }}>{{ $warehouse }}</option>
                @endforeach
            </select>
            @if ($errors->has('warehouses'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('roles') }}</strong>
                </div>
            @endif
        </div>
    
        
    
    
        <div class="form-group text-right mt-4">
            <input type="reset" class="btn btn-default m-1" value="{{ __('pages.clear') }}"/>
            <input type="submit" class="btn btn-success m-1" value="{{ __('pages.save') }}"/>
    
        </div>
    </form>