@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-12 margin-tb">
                                <div class="pull-left">
                                    <h2>Gestión de Promociones</h2>
                                </div>
                                <div class="pull-right">
                                    @can('config-promos-create')
                                        <a class="btn btn-success" href="{{ route('config_promo.create') }}"> Crear nueva
                                            Promo</a>
                                    @endcan
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-body">
                        <div class="container">
                            @if ($message = Session::get('success'))
                                <div class="alert alert-success">
                                    <p>{{ $message }}</p>
                                </div>
                            @endif


                            <table class="table table-sm table-striped">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Nombre</th>

                                        <th>Estatus</th>
                                        <th width="280px">Acción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($promos as $key => $promo)
                                        <tr>
                                            <td>{{ $promo->name }}</td>
                                            <td>
                                                @if ($promo->status)
                                                    <i class="fas fa-check-circle" style="color: green;"
                                                        aria-hidden="true"></i>
                                                @else
                                                    <i class="fas fa-times-circle" style="color: red;"
                                                        aria-hidden="true"></i>
                                                @endif
                                            </td>
                                            <td>
                                                @can('config-promos-editar')
                                                    {!! Form::open([
                                                        'method' => 'PUT',
                                                        'route' => ['config_promo.update', $promo->id],
                                                        'style' => 'display:inline',
                                                        'class' => '',
                                                    ]) !!}
                                                    {!! Form::submit('I/O', ['class' => 'btn btn-info']) !!}
                                                    {!! Form::close() !!}
                                                @endcan
                                                @can('config-promos-eliminar')
                                                    {!! Form::open([
                                                        'method' => 'DELETE',
                                                        'route' => ['config_promo.destroy', $promo->id],
                                                        'style' => 'display:inline',
                                                        'class' => 'delete',
                                                    ]) !!}
                                                    {!! Form::submit('x', ['class' => 'btn btn-danger btn-sm']) !!}
                                                    {!! Form::close() !!}
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        @endsection
