<?php

use Illuminate\Support\Facades\Route;
use Spatie\Permission\Contracts\Role;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('/auth/login');
});

Auth::routes();

Route::group(['middleware' => 'auth'], function () {

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::resource('clients',App\Http\Controllers\ClientController::class,['names'=>'clients']);

Route::resource('products',App\Http\Controllers\ProductController::class,['names'=>'products']);

Route::resource('orders',App\Http\Controllers\OrderController::class,['names'=>'orders']);

Route::resource('client_history',App\Http\Controllers\ClientHistoryController::class,['names'=>'client_history']);

Route::resource('users',App\Http\Controllers\UserController::class,['names'=>'users']);

Route::post('user_warehouse', [App\Http\Controllers\UserController::class, 'store_partner'])->name('users.store_partner');

Route::resource('warehouses',App\Http\Controllers\WarehouseController::class,['names'=>'warehouses']);

Route::resource('roles', App\Http\Controllers\RoleController::class,['names'=>'roles']);

Route::get('partner_create', [App\Http\Controllers\UserController::class, 'partner_create'])->name('partner_create');



Route::post('productsbytype', [App\Http\Controllers\OrderController::class, 'productsbytype']);
Route::post('productsbysearch', [App\Http\Controllers\OrderController::class, 'productsbysearch']);
Route::post('productsbymake', [App\Http\Controllers\OrderController::class, 'productsbymake']);
Route::post('productsbymodel', [App\Http\Controllers\OrderController::class, 'productsbymodel']);
Route::post('storeorder', [App\Http\Controllers\OrderController::class, 'storeorder'])->name('storeorder');

Route::resource('order_header',App\Http\Controllers\OrderHeaderController::class,['names'=>'order_header']);

Route::get('tree', [App\Http\Controllers\TreeController::class, 'index'])->name('tree');
Route::post('getTree', [App\Http\Controllers\TreeController::class, 'getTree'])->name('getTree');

Route::match(['get', 'post'], 'order_client', [App\Http\Controllers\OrderController::class, 'order_client'])->name('orders.order_client');


Route::match(['get', 'post'], 'order_manage', [App\Http\Controllers\OrderController::class, 'manage'])->name('orders.manage');
Route::match(['get', 'post'], 'order_history_manage', [App\Http\Controllers\OrderController::class, 'history_manage'])->name('orders.history_manage');
Route::match(['get', 'post'], 'order_client_history', [App\Http\Controllers\OrderController::class, 'order_client_history'])->name('orders.order_client_history');

Route::post('updatemanage', [App\Http\Controllers\OrderController::class, 'updatemanage'])->name('orders.updatemanage');

Route::resource('order_activities',App\Http\Controllers\OrderActivityController::class,['names'=>'order_activities']);

Route::resource('config_commissions',App\Http\Controllers\ConfigCommissionController::class,['names'=>'config_commissions']);

Route::post('cantonbyprovince', [App\Http\Controllers\UserController::class, 'cantonbyprovince']);
Route::post('parishbycanton', [App\Http\Controllers\UserController::class, 'parishbycanton']);

Route::match(['get', 'post'], 'order_create_history', [App\Http\Controllers\OrderController::class, 'create_history'])->name('orders.create_history');
Route::match(['get', 'post'], 'search_client', [App\Http\Controllers\ClientController::class, 'search'])->name('clients.search');
Route::get('/promos_manage', [App\Http\Controllers\PromoController::class, 'index_manage'])->name('promos_manage');
// Route::get('/promos', [App\Http\Controllers\PromoController::class, 'index'])->name('promos');
Route::resource('promos', App\Http\Controllers\PromoController::class,['names'=>'promos']);
Route::get('/multiuploads', [App\Http\Controllers\UploadPromoController::class, 'uploadForm'])->name('promos_admin');;
Route::post('/multiuploads', [App\Http\Controllers\UploadPromoController::class, 'uploadSubmit'])->name('uploadSubmit');;

Route::post('/salesDetails', [App\Http\Controllers\TreeController::class, 'salesDetails'])->name('tree.salesDetails');

Route::match(['get', 'post'],'users_manage', [App\Http\Controllers\UserController::class, 'index_manage'])->name('users_manage');
Route::post('/modifyParentUser', [App\Http\Controllers\UserController::class, 'modifyParentUser'])->name('modifyParentUser');

Route::match(['get', 'post'],'partners', [App\Http\Controllers\UserController::class, 'index_partners'])->name('partners');

Route::post('/updateUserStatus', [App\Http\Controllers\UserController::class, 'updateStatus'])->name('updateUserStatus');


});