<form action="<?php echo e(isset($route) ? $route : route('orders.updatemanage')); ?>" method="POST">
    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="_method" value="<?php echo e(isset($method) ? $method : 'POST'); ?>" />
    <div class="row">
        <input type="hidden" name="id" value="<?php echo e(old('id', $record->id)); ?>" />

        <div class="form-group col-12">
            <label for="DocDate"><?php echo e(__("orders.DocDate")); ?></label>
            <div class="input-group">
                <input type="date" class="form-control <?php echo e($errors->has('DocDate') ? ' is-invalid' : ''); ?>"
                    name="DocDate" id="DocDate" value="<?php echo e(old('DocDate', $record->DocDate)); ?>" placeholder="" disabled readonly>
                <div class="input-group-addon">
                    <label for="DocDate" class="fa fa-calendar">
                    </label>
                </div>
            </div>
            <?php if($errors->has('DocDate')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('DocDate')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-12">
            <label for="amount"><?php echo e(__('orders.amount')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('amount') ? ' is-invalid' : ''); ?>"
                name="amount" id="amount" value="<?php echo e(old('amount', $record->amount)); ?>" placeholder=""
                maxlength="254" disabled readonly>
            <?php if($errors->has('amount')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('amount')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="form-group col-12">
            <label for="expected_amount"><?php echo e(__('orders.expected_amount')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('expected_amount') ? ' is-invalid' : ''); ?>"
                name="expected_amount" id="expected_amount" value="<?php echo e(old('expected_amount', $record->expected_amount)); ?>" placeholder=""
                maxlength="254">
            <?php if($errors->has('expected_amount')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('expected_amount')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-6">
            <label for="status"><?php echo e(__('orders.status')); ?></label>
            <select class="form-control <?php echo e($errors->has('status') ? ' is-invalid' : ''); ?> select2" name="status"
                id="status" value="<?php echo e(old('status', $record->status)); ?>" placeholder="" maxlength="15">
                <option value="Cerrado sin facturar" <?php echo e($record->status == "Cerrado sin facturar"? "selected":""); ?>>Cerrado sin facturar</option>
                <option value="Cotizado" <?php echo e($record->status == "Cotizado"? "selected":""); ?>>Cotizado</option>
                <option value="En negociacion" <?php echo e($record->status == "En negociacion"? "selected":""); ?>>En negociación</option>
                <option value="Facturado" <?php echo e($record->status == "Facturado"? "selected":""); ?>>Facturado</option>
                

            </select>
            <?php if($errors->has('status')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('status')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="form-group col-6">
            <label for="progress"><?php echo e(__('orders.progress')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('progress') ? ' is-invalid' : ''); ?>"
                name="progress" id="progress" value="<?php echo e(old('progress', $record->progress)); ?>" placeholder=""
                maxlength="254" disabled readonly>
            <?php if($errors->has('progress')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('progress')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
        


        <div class="form-group text-right mt-4 ">
            <input type="submit" class="btn btn-primary w-100" value="Save" />

        </div>
    </div>
</form>
<?php $__env->startPush('custom-scripts'); ?>
    <script type="module">
        $(document).ready(function() {

            // let order_details = [];


            $('.select2').select2({
                theme: "classic"
            });

        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/b41wpxslh789/public_html/stagingsts/gte/resources/views/forms/order_manage.blade.php ENDPATH**/ ?>