<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-12 margin-tb">
                                <div class="pull-left">
                                    <h2>Gestión de Promociones</h2>
                                </div>
                                <div class="pull-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config-promos-create')): ?>
                                        <a class="btn btn-success" href="<?php echo e(route('config_promo.create')); ?>"> Crear nueva
                                            Promo</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-body">
                        <div class="container">
                            <?php if($message = Session::get('success')): ?>
                                <div class="alert alert-success">
                                    <p><?php echo e($message); ?></p>
                                </div>
                            <?php endif; ?>


                            <table class="table table-sm table-striped">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Nombre</th>

                                        <th>Estatus</th>
                                        <th width="280px">Acción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $promos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $promo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($promo->name); ?></td>
                                            <td>
                                                <?php if($promo->status): ?>
                                                    <i class="fas fa-check-circle" style="color: green;"
                                                        aria-hidden="true"></i>
                                                <?php else: ?>
                                                    <i class="fas fa-times-circle" style="color: red;"
                                                        aria-hidden="true"></i>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config-promos-editar')): ?>
                                                    <?php echo Form::open([
                                                        'method' => 'PUT',
                                                        'route' => ['config_promo.update', $promo->id],
                                                        'style' => 'display:inline',
                                                        'class' => '',
                                                    ]); ?>

                                                    <?php echo Form::submit('I/O', ['class' => 'btn btn-info']); ?>

                                                    <?php echo Form::close(); ?>

                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config-promos-eliminar')): ?>
                                                    <?php echo Form::open([
                                                        'method' => 'DELETE',
                                                        'route' => ['config_promo.destroy', $promo->id],
                                                        'style' => 'display:inline',
                                                        'class' => 'delete',
                                                    ]); ?>

                                                    <?php echo Form::submit('x', ['class' => 'btn btn-danger btn-sm']); ?>

                                                    <?php echo Form::close(); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/servercw/public_html/sts/gte/resources/views/pages/promos/index_admin.blade.php ENDPATH**/ ?>