<form action="<?php echo e(isset($route) ? $route : url('storeorder')); ?>" method="POST">
    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="_method" value="<?php echo e(isset($method) ? $method : 'POST'); ?>" />
    <div class="row">
     

        <div class="form-group col-5">
            <label for="CardCode">CardCode</label>
            <select class="form-control <?php echo e($errors->has('CardCode') ? ' is-invalid' : ''); ?> select2" name="CardCode"
                id="CardCode" value="<?php echo e(old('CardCode', $model->CardCode)); ?>" placeholder="" maxlength="15">
                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($client->CardCode); ?>"
                        <?php echo e($client->CardCode == $model->CardCode ? 'selected' : ''); ?>>
                        <?php echo e($client->CardName); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </select>
            <?php if($errors->has('CardCode')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('CardCode')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-3">
            <label for="Comments">Comments</label>
            <input type="text" class="form-control <?php echo e($errors->has('Comments') ? ' is-invalid' : ''); ?>"
                name="Comments" id="Comments" value="<?php echo e(old('Comments', $model->Comments)); ?>" placeholder=""
                maxlength="254">
            <?php if($errors->has('Comments')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('Comments')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-2">
            <label for="DiscountPercent">DiscountPercent</label>
            <input type="number" class="form-control <?php echo e($errors->has('DiscountPercent') ? ' is-invalid' : ''); ?>"
                name="DiscountPercent" id="DiscountPercent"
                value="<?php echo e(old('DiscountPercent', $model->DiscountPercent)); ?>" placeholder="">
            <?php if($errors->has('DiscountPercent')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('DiscountPercent')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-2">
            <label for="warehouse_id">Bodega</label>
            <select class="form-control <?php echo e($errors->has('warehouse_id') ? ' is-invalid' : ''); ?> select2" name="warehouse_id"
                id="warehouse_id" value="<?php echo e(old('warehouse_id', $model->warehouse_id)); ?>" placeholder="" maxlength="15">
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wareshouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($wareshouse->id); ?>"
                        <?php echo e($wareshouse->id == $model->wareshouse_id ? 'selected' : ''); ?>>
                        <?php echo e($wareshouse->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </select>
            <?php if($errors->has('warehouse_id')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('warehouse_id')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-4">
            <label for="Product">Product</label>
            <select class="form-control <?php echo e($errors->has('Product') ? ' is-invalid' : ''); ?> select2" name="Product"
                id="Product" value="<?php echo e(old('Product', $model->Product)); ?>" placeholder="" maxlength="1">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($product->code); ?>" <?php echo e($product->code == $model->Product ? 'selected' : ''); ?>>
                        <?php echo e($product->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

        </div>

        <div class="form-group col-2">
            <label for="Type">Type</label>
            <select class="form-control <?php echo e($errors->has('Type') ? ' is-invalid' : ''); ?> select2" name="Type"
                id="Type" value="<?php echo e(old('Type', $model->Type)); ?>" placeholder="" maxlength="1">
                <option value="">-- Seleccione Categoría --</option>
                <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($type->type); ?>" <?php echo e($type->type == $model->Type ? 'selected' : ''); ?>>
                        <?php echo e($type->type); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>


        <div class="form-group col-3">
            <label for="Make">Make</label>
            <select class="form-control <?php echo e($errors->has('Make') ? ' is-invalid' : ''); ?> select2" name="Make"
                id="Make" value="<?php echo e(old('Make', $model->Make)); ?>" placeholder="" maxlength="1">
                <option value="I" <?php echo e($model->Make == 'I' ? 'selected' : ''); ?>>I</option>
                <option value="S" <?php echo e($model->Make == 'S' ? 'selected' : ''); ?>>S</option>
            </select>
        </div>


        <div class="form-group col-2">
            <label for="Model">Model</label>
            <select class="form-control <?php echo e($errors->has('Model') ? ' is-invalid' : ''); ?> select2" name="Model"
                id="Model" value="<?php echo e(old('Model', $model->Model)); ?>" placeholder="" maxlength="1">
                <option value="I" <?php echo e($model->Model == 'I' ? 'selected' : ''); ?>>I</option>
                <option value="S" <?php echo e($model->Model == 'S' ? 'selected' : ''); ?>>S</option>
            </select>
        </div>

        <div class="form-group col-1 p-3">
            <a class="btn btn-success" value="Add" id="AddProduct"> + </a>
        </div>


        <div class="form-group col-12">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Type</th>
                        <th>Code</th>
                        <th>Make</th>
                        <th>Model</th>
                        <th>Measure</th>
                        <th>Quantity</th>
                        <th>Price</th>
                        <th>Discount</th>
                        <th>Total</th>
                        <th>Comments</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    
                </tbody>
            </table>
        </div>

        <div class="form-group col-12">
            <div class="float-end">
            <h3 id="total"></h3>
            </div>
        </div>


        <div class="form-group text-right ">
            <input type="reset" class="btn btn-default" value="Clear" />
            <input type="submit" class="btn btn-primary" value="Save" />

        </div>
    </div>
</form>
<?php $__env->startPush('custom-scripts'); ?>
    
    
    
    <script type="module">
        $(document).ready(function() {
            let products = <?php echo json_encode($products, 15, 512) ?>;

            let row_index = 0;

            // let order_details = [];


            $('.select2').select2({
                theme: "classic"
            });

            $('#Type').on('change', function() {
                var type = this.value;
                $("#Make").html('');
                $.ajax({
                    url: "<?php echo e(url('productsbytype')); ?>",
                    type: "POST",
                    data: {
                        type: type,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#Make').html('<option value="">-- Seleccione Marca --</option>');
                        $.each(result.makes, function(key, value) {
                            $("#Make").append('<option value="' + value
                                .make + '">' + value.make + '</option>');
                        });
                        fillProducts(result.products);
                        $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
                    }
                });
            });

            //do the same for make

            $('#Make').on('change', function() {
                var make = this.value;
                var type = $('#Type').val();
                $.ajax({
                    url: "<?php echo e(url('productsbymake')); ?>",
                    type: "POST",
                    data: {
                        make: make,
                        type: type,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
                        $.each(result.models, function(key, value) {
                            $("#Model").append('<option value="' + value
                                .model + '">' + value.model + '</option>');
                        });
                        fillProducts(result.products);
                    }
                });
            });

            //do the same for model
            $('#Model').on('change', function() {
                var model = this.value;
                var make = $('#Make').val();
                var type = $('#Type').val();
                $.ajax({
                    url: "<?php echo e(url('productsbymodel')); ?>",
                    type: "POST",
                    data: {
                        model: model,
                        make: make,
                        type: type,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function(result) {
                        fillProducts(result.products);
                    }
                });
            });

            function fillProducts(products) {
                $("#Product").html('');
                $.each(products, function(key, value) {
                    $("#Product").append('<option value="' + value
                        .code + '">' + value.name + '</option>');
                });
            }

            //listener for new element .deleteRow

            $(".deleteRow").click(function() {
                console.log('hello');
                var product_code = $(this).data("product_code");
                $('#' + product_code).remove();
            });

            //add product to table
            $("#AddProduct").click(function() {
                const product_code = $('#Product').val();
                
                if(!product_code) {
                    alert('Debe seleccionar un producto');
                    return;
                }
                
                const product = products.find(product => {
                    return product.code == product_code;
                });

                const productExists = $('#' + product.code + '_quantity').length > 0;

                if(productExists) {
                    console.log("🚀 ~ file: order.blade.php:258 ~ $ ~ productExists:", productExists);
                    const quantity = $('#' + product.code + '_quantity').val();
                    $('#' + product.code + '_quantity').val(parseInt(quantity) + 1);
                    //update total
                    const total = $('#' + product.code + '_total').text();
                    $('#' + product.code + '_total').text(parseFloat(total) + parseFloat(product.price));
                    calculateTotal();
                    return;
                }

                const row = '<tr id="' + product.code + '">' +
                    '<td>' + product.type +'</td>' +
                    '<td><input class="form-control" value=" ' + product.code +'" name="details[' + row_index + '][code]" readonly/></td>' +
                    '<td>' + product.make + '</td>' +
                    '<td>' + product.model + '</td>' +
                    '<td>' + product.measure + '</td>' +
                    '<td><input id="'+ product.code +'_quantity" class="form-control" value="' + 1 + '" name="details[' + row_index + '][quantity]" type="number" onclick="updateQuantity(\'' + product.code + '\')"/></td>'+
                    '<td><input class="form-control" value=" ' + product.price + '" name="details['+ row_index +'][price]" readonly/></td>'+
                    '<td>' + 0 + '</td>' +
                    '<td id="'+ product.code +'_total">' + product.price + '</td>' +
                    '<td><input class="form-control" name="details[' + row_index + '][observations]" /> </td>'+
                    '<td><a class="btn btn-danger deleteRow"  product_code="' + product.code + '" onclick="deleteRow(\'' + product.code + '\')"> x </a></td>'+
                    '</tr>';
                $('tbody').append(row);


                row_index++;
                calculateTotal();
            });

            function calculateTotal() {
                var total = 0;
                $('tbody tr').each(function() {
                    var subtotal = $(this).find('td').eq(8).text();
                    total += parseFloat(subtotal);
                });
                $('#total').text(total);
            }

            const updateQuantity = function(product_code) {
                var product = products.find(product => {
                    return product.code == product_code;
                });
                const total = $('#' + product.code + '_total').text();
                const quantity = $('#' + product.code + '_quantity').val();

                $('#' + product.code + '_total').text( quantity * parseFloat(product.price));
                calculateTotal();
            }

            const deleteRow = function(product_code) {
                $('#' + product_code).remove();
            }

            window.updateQuantity = updateQuantity;
            window.deleteRow = deleteRow;
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /Applications/MAMP/htdocs/multinivel-gte/resources/views/forms/order.blade.php ENDPATH**/ ?>