<form action="<?php echo e(isset($route) ? $route : route('users.store_partner')); ?>" method="POST" class="row">
    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="_method" value="<?php echo e(isset($method) ? $method : 'POST'); ?>" />
    <fieldset class="row">
        <legend class="scheduler-border"><?php echo e(__('users.sectionParent')); ?></legend>

        <div class="form-group col-md-6">
            <label for="parent_document"><?php echo e(__('users.Parent Document')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('parent_document') ? ' is-invalid' : ''); ?>"
                name="parent_document" id="parent_document" value="<?php echo e($parent->document); ?>" placeholder="" maxlength="13"
                required="required" readonly>
            <?php if($errors->has('parent_document')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('parent_document')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
        <div class="form-group col-md-6">
            <label for="parent_name"><?php echo e(__('users.Parent Name')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('parent_name') ? ' is-invalid' : ''); ?>"
                name="parent_name" id="parent_name" value="<?php echo e($parent->name); ?>" placeholder="" maxlength="13"
                required="required" readonly>
            <?php if($errors->has('parent_name')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('parent_name')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    </fieldset>
    <fieldset class="row">
        <legend class="scheduler-border"><?php echo e(__('users.sectionUser')); ?></legend>

        <div class="form-group col-md-4">
            <label for="middlename"><?php echo e(__('users.MiddleName')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" name="middlename"
                id="middlename" value="<?php echo e(old('middlename', $model->middlename)); ?>" placeholder="" maxlength="255"
                required="required">
            <?php if($errors->has('middlename')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('middlename')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-md-4">
            <label for="lastname"><?php echo e(__('users.LastName')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('lastname') ? ' is-invalid' : ''); ?>" name="lastname"
                id="lastname" value="<?php echo e(old('lastname', $model->lastname)); ?>" placeholder="" maxlength="255"
                required="required">
            <?php if($errors->has('lastname')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('lastname')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-md-4">
            <label for="names"><?php echo e(__('users.Names')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('names') ? ' is-invalid' : ''); ?>" name="names"
                id="names" value="<?php echo e(old('names', $model->names)); ?>" placeholder="" maxlength="255"
                required="required">
            <?php if($errors->has('names')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('names')); ?></strong>
                </div>
            <?php endif; ?>
        </div>


        <div class="form-group col-md-4">
            <label for="document"><?php echo e(__('users.Document')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('document') ? ' is-invalid' : ''); ?>"
                name="document" id="document" value="<?php echo e(old('document', $model->document)); ?>" placeholder=""
                maxlength="13" required="required">
            <?php if($errors->has('document')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('document')); ?></strong>
                </div>
            <?php endif; ?>
        </div>



        <div class="form-group col-md-4">
            <label for="email"><?php echo e(__('users.Email')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email"
                id="email" value="<?php echo e(old('email', $model->email)); ?>" placeholder="" maxlength="255"
                required="required">
            <?php if($errors->has('email')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('email')); ?></strong>
                </div>
            <?php endif; ?>
        </div>


        <div class="form-group col-md-4">
            <label for="birthday"><?php echo e(__('users.Birthday')); ?></label>
            <div class="input-group">
                <input type="date" class="form-control <?php echo e($errors->has('birthday') ? ' is-invalid' : ''); ?>"
                    name="birthday" id="birthday" value="<?php echo e(old('birthday', $model->birthday)); ?>" placeholder="">
                <div class="input-group-addon">
                    <label for="birthday" class="fa fa-calendar">
                    </label>
                </div>
            </div>
            <?php if($errors->has('birthday')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('birthday')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <input type="hidden" name="country" value="EC" />

        

        <div class="form-group  col-md-3">
            <label for="province"><?php echo e(__('users.Province')); ?></label>
            <select class="form-control <?php echo e($errors->has('province') ? ' is-invalid' : ''); ?> select2" name="province"
                id="province" value="<?php echo e(old('province', $model->province)); ?>" placeholder="" maxlength="1">
                <option value="">-- Seleccione Provincia --</option>
                <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($province->id); ?>" <?php echo e($model->province == $province->id ? 'selected' : ''); ?>>
                        <?php echo e($province->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php if($errors->has('province')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('province')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-3">
            <label for="canton"><?php echo e(__('users.Canton')); ?></label>
            <select class="form-control <?php echo e($errors->has('canton') ? ' is-invalid' : ''); ?> select2" name="canton"
                id="canton" value="<?php echo e(old('canton', $model->canton)); ?>" placeholder="" maxlength="1">
                <option value="">-- Seleccione Cantón --</option>
            </select>
            <?php if($errors->has('canton')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('canton')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-3">
            <label for="parish"><?php echo e(__('users.Parish')); ?></label>
            <select class="form-control <?php echo e($errors->has('parish') ? ' is-invalid' : ''); ?> select2" name="parish"
                id="parish" value="<?php echo e(old('parish', $model->parish)); ?>" placeholder="" maxlength="1">
                <option value="">-- Seleccione Parroquía --</option>
            </select>
            <?php if($errors->has('parish')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('parish')); ?></strong>
                </div>
            <?php endif; ?>
        </div>


        <div class="form-group  col-md-3">
            <label for="address"><?php echo e(__('users.Address')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('address') ? ' is-invalid' : ''); ?>"
                name="address" id="address" value="<?php echo e(old('address', $model->address)); ?>" placeholder=""
                maxlength="255">
            <?php if($errors->has('address')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('address')); ?></strong>
                </div>
            <?php endif; ?>
        </div>


        <div class="form-group   col-md-3">
            <label for="movile"><?php echo e(__('users.Movile')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('movile') ? ' is-invalid' : ''); ?>" name="movile"
                id="movile" value="<?php echo e(old('movile', $model->movile)); ?>" placeholder="" maxlength="50">
            <?php if($errors->has('movile')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('movile')); ?></strong>
                </div>
            <?php endif; ?>
        </div>


        

           

    <div class="form-group   col-md-3">
        <label for="phone"><?php echo e(__('users.Phone')); ?></label>
        <input type="text" class="form-control <?php echo e($errors->has('phone') ? ' is-invalid' : ''); ?>" name="phone"
            id="phone" value="<?php echo e(old('phone', $model->phone)); ?>" placeholder="" maxlength="50">
        <?php if($errors->has('phone')): ?>
            <div class="invalid-feedback">
                <strong><?php echo e($errors->first('phone')); ?></strong>
            </div>
        <?php endif; ?>
    </div>

        <div class="form-grou col-md-3">
            <label for="genre"><?php echo e(__('users.Genre')); ?></label>
            <select class="form-control <?php echo e($errors->has('genre') ? ' is-invalid' : ''); ?>" name="genre"
                id="genre">
                <option value="M" <?php echo e(old('genre', $model->genre) == 'M' ? 'selected' : ''); ?>>M</option>
                <option value="F" <?php echo e(old('genre', $model->genre) == 'F' ? 'selected' : ''); ?>>F</option>
            </select>
            <?php if($errors->has('genre')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('genre')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-3">
            <label for="civil_status"><?php echo e(__('users.Civil Status')); ?></label>
            <select class="form-control <?php echo e($errors->has('civil_status') ? ' is-invalid' : ''); ?>" name="civil_status"
                id="civil_status">
                <option value="S" <?php echo e(old('civil_status', $model->civil_status) == 'S' ? 'selected' : ''); ?>>S
                </option>
                <option value="C" <?php echo e(old('civil_status', $model->civil_status) == 'C' ? 'selected' : ''); ?>>C
                </option>
                <option value="D" <?php echo e(old('civil_status', $model->civil_status) == 'D' ? 'selected' : ''); ?>>D
                </option>
                <option value="V" <?php echo e(old('civil_status', $model->civil_status) == 'V' ? 'selected' : ''); ?>>V
                </option>
            </select>
            <?php if($errors->has('civil_status')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('civil_status')); ?></strong>
                </div>
            <?php endif; ?>
        </div>



    </fieldset>
    <fieldset class="row">
        <legend class="scheduler-border"><?php echo e(__('users.sectionBank')); ?></legend>

        <div class="form-group   col-md-4">
            <label for="bank"><?php echo e(__('users.Bank')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('bank') ? ' is-invalid' : ''); ?>"
                name="bank" id="bank" value="<?php echo e(old('bank', $model->bank)); ?>" placeholder=""
                maxlength="100">
            <?php if($errors->has('bank')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('bank')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-4">
            <label for="account_number"><?php echo e(__('users.Account Number')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('account_number') ? ' is-invalid' : ''); ?>"
                name="account_number" id="account_number"
                value="<?php echo e(old('account_number', $model->account_number)); ?>" placeholder="" maxlength="100">
            <?php if($errors->has('account_number')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('account_number')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-4">
            <label for="account_type"><?php echo e(__('users.Account Type')); ?></label>
            <select class="form-control <?php echo e($errors->has('account_type') ? ' is-invalid' : ''); ?>" name="account_type"
                id="account_type">
                <option value="A" <?php echo e(old('account_type', $model->account_type) == 'Ahorros' ? 'selected' : ''); ?>>
                    A</option>
                <option value="C"
                    <?php echo e(old('account_type', $model->account_type) == 'Corriente' ? 'selected' : ''); ?>>C</option>
            </select>
            <?php if($errors->has('account_type')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('account_type')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    </fieldset>

    <div class="form-group text-right mt-4">
        
        <input type="submit" class="btn btn-primary" value="<?php echo e(__('pages.save')); ?>" />

    </div>
</form>
<?php $__env->startPush('custom-scripts'); ?>

    <script type="module">
        $(document).ready(function() {

            $('.select2').select2({
                theme: "classic"
            });

            $('#province').on('change', function() {
                var province = this.value;
                $("#canton").html('');
                $.ajax({
                    url: "<?php echo e(url('cantonbyprovince')); ?>",
                    type: "POST",
                    data: {
                        province_id: province,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#canton').html('<option value="">-- Seleccione Canton --</option>');
                        $.each(result, function(key, value) {
                            $("#canton").append('<option value="' + value
                                .id + '">' + value.name + '</option>');
                        });
                        // fillProducts(result.products);
                        $('#parish').html('<option value="">-- Seleccione Parroquia --</option>');
                    }
                });
            });

            //do the same for make

            $('#canton').on('change', function() {
                var canton = this.value;
                var province = $('#province').val();
                $.ajax({
                    url: "<?php echo e(url('parishbycanton')); ?>",
                    type: "POST",
                    data: {
                        canton_id: canton,
                        province_id: province,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#parish').html('<option value="">-- Seleccione Parroquia --</option>');
                        $.each(result, function(key, value) {
                            $("#parish").append('<option value="' + value
                                .id + '">' + value.name + '</option>');
                        });
                        // fillProducts(result.products);
                    }
                });
            });

            
        });
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home2/servercw/public_html/sts/gte/resources/views/forms/partner_user.blade.php ENDPATH**/ ?>