
    <form action="<?php echo e(isset($route) ? $route : route('users.store')); ?>" method="POST" class="row">
        <?php echo e(csrf_field()); ?>

        <input type="hidden" name="_method" value="<?php echo e(isset($method) ? $method : 'POST'); ?>" />
        <div class="form-group col-md-2">
            <label for="name"><?php echo e(__("users.Name")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" name="name"
                id="name" value="<?php echo e(old('name', $model->name)); ?>" placeholder="" maxlength="255" required="required">
            <?php if($errors->has('name')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('name')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group col-md-2">
            <label for="email"><?php echo e(__("users.Email")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email"
                id="email" value="<?php echo e(old('email', $model->email)); ?>" placeholder="" maxlength="255" required="required">
            <?php if($errors->has('email')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('email')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group col-md-2">
            <label for="document"><?php echo e(__("users.Document")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('document') ? ' is-invalid' : ''); ?>" name="document"
                id="document" value="<?php echo e(old('document', $model->document)); ?>" placeholder="" maxlength="13"
                required="required">
            <?php if($errors->has('document')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('document')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group col-md-2">
            <label for="parent_document"><?php echo e(__("users.Parent Document")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('parent_document') ? ' is-invalid' : ''); ?>"
                name="parent_document" id="parent_document" value="<?php echo e(old('parent_document', $model->parent_document)); ?>"
                placeholder="" maxlength="13" required="required">
            <?php if($errors->has('parent_document')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('parent_document')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-2">
            <label for="type"><?php echo e(__("users.Type")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('type') ? ' is-invalid' : ''); ?>" name="type"
                id="type" value="<?php echo e(old('type', $model->type)); ?>" placeholder="" maxlength="100">
            <?php if($errors->has('type')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('type')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group col-md-2">
          <label for="password"><?php echo e(__("users.Password")); ?></label>
          <input type="password" class="form-control <?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>"
              name="password" id="password" value="<?php echo e(old('password', $model->password)); ?>"
              placeholder="" maxlength="13" required="required">
          <?php if($errors->has('password')): ?>
              <div class="invalid-feedback">
                  <strong><?php echo e($errors->first('password')); ?></strong>
              </div>
          <?php endif; ?>
      </div>
    
        <div class="form-group  col-md-2">
            <label for="address"><?php echo e(__("users.Address")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('address') ? ' is-invalid' : ''); ?>" name="address"
                id="address" value="<?php echo e(old('address', $model->address)); ?>" placeholder="" maxlength="255">
            <?php if($errors->has('address')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('address')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group   col-md-2">
            <label for="movile"><?php echo e(__("users.Movile")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('movile') ? ' is-invalid' : ''); ?>" name="movile"
                id="movile" value="<?php echo e(old('movile', $model->movile)); ?>" placeholder="" maxlength="50">
            <?php if($errors->has('movile')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('movile')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group   col-md-2">
            <label for="phone"><?php echo e(__("users.Phone")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('phone') ? ' is-invalid' : ''); ?>" name="phone"
                id="phone" value="<?php echo e(old('phone', $model->phone)); ?>" placeholder="" maxlength="50">
            <?php if($errors->has('phone')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('phone')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-grou col-md-2">
            <label for="genre"><?php echo e(__("users.Genre")); ?></label>
            <select class="form-control <?php echo e($errors->has('genre') ? ' is-invalid' : ''); ?>" name="genre" id="genre">
                <option value="M" <?php echo e(old('genre', $model->genre) == 'M' ? 'selected' : ''); ?>>M</option>
                <option value="F" <?php echo e(old('genre', $model->genre) == 'F' ? 'selected' : ''); ?>>F</option>
            </select>
            <?php if($errors->has('genre')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('genre')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group col-md-2">
            <label for="birthday"><?php echo e(__("users.Birthday")); ?></label>
            <div class="input-group">
                <input type="date" class="form-control <?php echo e($errors->has('birthday') ? ' is-invalid' : ''); ?>"
                    name="birthday" id="birthday" value="<?php echo e(old('birthday', $model->birthday)); ?>" placeholder="">
                <div class="input-group-addon">
                    <label for="birthday" class="fa fa-calendar">
                    </label>
                </div>
            </div>
            <?php if($errors->has('birthday')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('birthday')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group  col-md-2">
            <label for="civil_status"><?php echo e(__("users.Civil Status")); ?></label>
            <select class="form-control <?php echo e($errors->has('civil_status') ? ' is-invalid' : ''); ?>" name="civil_status"
                id="civil_status">
                <option value="S" <?php echo e(old('civil_status', $model->civil_status) == 'S' ? 'selected' : ''); ?>>S</option>
                <option value="C" <?php echo e(old('civil_status', $model->civil_status) == 'C' ? 'selected' : ''); ?>>C</option>
                <option value="D" <?php echo e(old('civil_status', $model->civil_status) == 'D' ? 'selected' : ''); ?>>D</option>
                <option value="V" <?php echo e(old('civil_status', $model->civil_status) == 'V' ? 'selected' : ''); ?>>V</option>
            </select>
            <?php if($errors->has('civil_status')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('civil_status')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group  col-md-2">
            <label for="country"><?php echo e(__("users.Country")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('country') ? ' is-invalid' : ''); ?>" name="country"
                id="country" value="<?php echo e(old('country', $model->country)); ?>" placeholder="" maxlength="100">
            <?php if($errors->has('country')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('country')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group  col-md-2">
            <label for="province"><?php echo e(__("users.Province")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('province') ? ' is-invalid' : ''); ?>"
                name="province" id="province" value="<?php echo e(old('province', $model->province)); ?>" placeholder=""
                maxlength="100">
            <?php if($errors->has('province')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('province')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group  col-md-2">
            <label for="city"><?php echo e(__("users.City")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('city') ? ' is-invalid' : ''); ?>" name="city"
                id="city" value="<?php echo e(old('city', $model->city)); ?>" placeholder="" maxlength="100">
            <?php if($errors->has('city')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('city')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group   col-md-2">
            <label for="bank"><?php echo e(__("users.Bank")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('bank') ? ' is-invalid' : ''); ?>" name="bank"
                id="bank" value="<?php echo e(old('bank', $model->bank)); ?>" placeholder="" maxlength="100">
            <?php if($errors->has('bank')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('bank')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group  col-md-2">
            <label for="account_number"><?php echo e(__("users.Account Number")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('account_number') ? ' is-invalid' : ''); ?>"
                name="account_number" id="account_number" value="<?php echo e(old('account_number', $model->account_number)); ?>"
                placeholder="" maxlength="100">
            <?php if($errors->has('account_number')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('account_number')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group  col-md-2">
            <label for="account_type"><?php echo e(__("users.Account Type")); ?></label>
            <select class="form-control <?php echo e($errors->has('account_type') ? ' is-invalid' : ''); ?>" name="account_type"
                id="account_type">
                <option value="A" <?php echo e(old('account_type', $model->account_type) == 'Ahorros' ? 'selected' : ''); ?>>A</option>
                <option value="C" <?php echo e(old('account_type', $model->account_type) == 'Corriente' ? 'selected' : ''); ?>>C</option>
            </select>
            <?php if($errors->has('account_type')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('account_type')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group col-md-2">
            <label for="entry_date"><?php echo e(__("users.Entry Date")); ?></label>
            <div class="input-group">
                <input type="date" class="form-control <?php echo e($errors->has('entry_date') ? ' is-invalid' : ''); ?>"
                    name="entry_date" id="entry_date" value="<?php echo e(old('entry_date', $model->entry_date)); ?>" placeholder="">
                <div class="input-group-addon">
                    <label for="entry_date" class="fa fa-calendar">
                    </label>
                </div>
            </div>
            <?php if($errors->has('entry_date')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('entry_date')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group  col-md-2">
            <label for="roles"><?php echo e(__("users.Roles")); ?></label>
            <select class="form-control <?php echo e($errors->has('roles') ? ' is-invalid' : ''); ?> select2" name="roles"
                id="roles">
                <option value=""><?php echo e(__('users.select')); ?>...</option>
                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($role); ?>" <?php echo e(in_array($role,$userRoles) ? 'selected' : ''); ?>><?php echo e($role); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php if($errors->has('roles')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('roles')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        <div class="form-group  col-md-2">
            <label for="warehouses"><?php echo e(__("users.warehouses")); ?></label>
            <select class="form-control <?php echo e($errors->has('warehouses') ? ' is-invalid' : ''); ?> select2" name="warehouses[]"
                id="warehouses" multiple>
                <option value=""><?php echo e(__('users.select')); ?>...</option>
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($key); ?>" <?php echo e(in_array($warehouse,$userWarehouses) ? 'selected' : ''); ?>><?php echo e($warehouse); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php if($errors->has('warehouses')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('roles')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
    
        
    
    
        <div class="form-group text-right mt-4">
            <input type="reset" class="btn btn-default m-1" value="<?php echo e(__('pages.clear')); ?>"/>
            <input type="submit" class="btn btn-success m-1" value="<?php echo e(__('pages.save')); ?>"/>
    
        </div>
    </form><?php /**PATH /home2/servercw/public_html/sts/gte/resources/views/forms/user.blade.php ENDPATH**/ ?>