<form action="<?php echo e(isset($route) ? $route : route('order_activities.store')); ?>" method="POST" class="inline">
    <?php echo e(csrf_field()); ?>

    <div class="row">
    <input type="hidden" name="_method" value="<?php echo e(isset($method) ? $method : 'POST'); ?>" />
    <input type="hidden" name="order_id" value="<?php echo e(old('order_id', $record->id)); ?>" />
    <input type="hidden" name="user_id" value="<?php echo e(old('user_id', $record->user_id)); ?>" />

    <div class="form-group col-6">
        <label for="activity"><?php echo e(__('orders.activity')); ?></label>
        
        <select class="form-control <?php echo e($errors->has('activity') ? ' is-invalid' : ''); ?> select2" name="activity"
            id="activity" value="<?php echo e(old('activity', $record->activity)); ?>" placeholder="" maxlength="15">
            <option value="Llamada" <?php echo e($record->activity == "Llamada"? "selected":""); ?>>Llamada</option>
            <option value="Correo" <?php echo e($record->activity == "Correo"? "selected":""); ?>>Correo</option>
            <option value="Whatsapp/Redes Sociales" <?php echo e($record->activity == "Whatsapp/Redes Sociales"? "selected":""); ?>>Whatsapp/Redes Sociales</option>
            <option value="Otro" <?php echo e($record->activity == "Otro"? "selected":""); ?>>Otro</option>
            <option value="Incontactable" <?php echo e($record->activity == "Incontactable"? "selected":""); ?>>Incontactable</option>
        </select>
        
        <?php if($errors->has('activity')): ?>
            <div class="invalid-feedback">
                <strong><?php echo e($errors->first('activity')); ?></strong>
            </div>
        <?php endif; ?>
    </div>

    <div class="form-group col-6">
      <label for="followup_date"><?php echo e(__('orders.followup_date')); ?></label>
      <div class="input-group">
          <input type="date" class="form-control <?php echo e($errors->has('followup_date') ? ' is-invalid' : ''); ?>"
              name="followup_date" id="followup_date" value="<?php echo e(old('followup_date', $record->followup_date)); ?>"
              placeholder="" min="<?php echo e(date('Y-m-d')); ?>">
          <div class="input-group-addon">
              <label for="followup_date" class="fa fa-calendar">
              </label>
          </div>
      </div>
      <?php if($errors->has('followup_date')): ?>
          <div class="invalid-feedback">
              <strong><?php echo e($errors->first('followup_date')); ?></strong>
          </div>
      <?php endif; ?>
  </div>

    <div class="form-group col-11">
        <label for="comments"><?php echo e(__('orders.comments')); ?></label>
        <input type="text" class="form-control <?php echo e($errors->has('comments') ? ' is-invalid' : ''); ?>" name="comments"
            id="comments" value="<?php echo e(old('comments', $record->comments)); ?>" placeholder="" maxlength="255">
        <?php if($errors->has('comments')): ?>
            <div class="invalid-feedback">
                <strong><?php echo e($errors->first('comments')); ?></strong>
            </div>
        <?php endif; ?>
    </div>

    
    <div class="form-group col-1 p-3">
      
      <input type="submit" class="btn btn-success" value="+" />
    </div>

    
    </div>
</form>
<?php /**PATH /Applications/MAMP/htdocs/multinivel-gte/resources/views/forms/order_activity.blade.php ENDPATH**/ ?>